/*
 * Decompiled with CFR 0.152.
 */
package orbital.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import orbital.logic.functor.Function;

public class Filters {
    public static final Function all = new Function(){

        public Object apply(Object d) {
            return d;
        }

        public String toString() {
            return "*";
        }
    };
    public static final Function first = new Function(){

        public Object apply(Object d) {
            ArrayList f = new ArrayList(1);
            f.add(((Collection)d).iterator().next());
            return f;
        }

        public String toString() {
            return "first";
        }
    };
    public static final Function last = new Function(){

        public Object apply(Object d) {
            ArrayList<Object> f = new ArrayList<Object>(1);
            Object l = null;
            Iterator i = ((Collection)d).iterator();
            while (i.hasNext()) {
                l = i.next();
            }
            f.add(l);
            return f;
        }

        public String toString() {
            return "last";
        }
    };

    public static Function ranged(final int min, final int max) {
        return new Function(){

            public Object apply(Object d) {
                ArrayList f = new ArrayList(max - min + 1);
                int count = 0;
                Iterator i = ((Collection)d).iterator();
                while (i.hasNext()) {
                    Object el = i.next();
                    if (count >= min && count <= max) {
                        f.add(el);
                    }
                    ++count;
                }
                return f;
            }

            public String toString() {
                return "ranged(" + min + "," + max + ")";
            }
        };
    }

    public static Function top(int number) {
        return Filters.ranged(0, number - 1);
    }

    public static Function top(final double number, boolean percent) {
        if (!percent) {
            return Filters.top((int)number);
        }
        if (!(0.0 <= number) || !(number <= 100.0)) {
            throw new IllegalArgumentException("number must be a valid percentage in [0,100]");
        }
        return new Function(){

            public Object apply(Object d) {
                return Filters.top((int)Math.ceil(number * (double)((Collection)d).size() / 100.0)).apply(d);
            }
        };
    }
}

