/*
 * Decompiled with CFR 0.152.
 */
package orbital.robotic;

import orbital.robotic.Direction;
import orbital.robotic.Move;
import orbital.robotic.Position;

public class Moving
extends Position {
    private static final long serialVersionUID = 4953088411018850978L;
    private Direction direction;

    public Moving(int x, int y, Direction dir) {
        super(x, y);
        this.direction = dir;
    }

    public Moving(Position p, Direction dir) {
        this(p.x, p.y, dir);
    }

    public Moving(int x, int y, int dir) {
        this(x, y, new Direction(dir));
    }

    public Moving(Position p, int dir) {
        this(p.x, p.y, new Direction(dir));
    }

    public Moving(int x, int y) {
        this(x, y, new Direction(270));
    }

    public Moving(Position p) {
        this(p.x, p.y);
    }

    public Moving(Moving p) {
        this(p.x, p.y, new Direction(p.getDirection()));
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction newDirection) {
        this.direction = newDirection;
    }

    public Object clone() {
        Moving c = (Moving)super.clone();
        c.setDirection((Direction)this.getDirection().clone());
        return c;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Moving) {
            return super.equals(obj) && this.direction.equals(((Moving)obj).direction);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.direction.hashCode();
    }

    public void slideDirection(int dir) {
        switch (dir) {
            case 0: {
                ++this.x;
                break;
            }
            case 45: {
                ++this.x;
                ++this.y;
                break;
            }
            case 90: {
                ++this.y;
                break;
            }
            case 135: {
                ++this.y;
                --this.x;
                break;
            }
            case 180: {
                --this.x;
                break;
            }
            case 225: {
                --this.y;
                --this.x;
                break;
            }
            case 270: {
                --this.y;
                break;
            }
            case 315: {
                --this.y;
                ++this.x;
                break;
            }
            default: {
                throw new IllegalStateException("Direction is invalid: " + dir);
            }
        }
    }

    public void slide(int dir) {
        this.slideDirection(this.direction.getTurned(dir));
    }

    public void move(char mv) {
        switch (mv) {
            case ' ': {
                break;
            }
            case '#': {
                break;
            }
            case '_': {
                break;
            }
            case '/': {
                break;
            }
            case '*': {
                break;
            }
            case 'r': {
                this.direction.turn(90);
                break;
            }
            case 'R': {
                this.slide(90);
                break;
            }
            case 'f': {
                this.direction.turn(0);
                break;
            }
            case 'F': {
                this.slide(0);
                break;
            }
            case 'l': {
                this.direction.turn(-90);
                break;
            }
            case 'L': {
                this.slide(-90);
                break;
            }
            case 'b': {
                this.direction.turn(180);
                break;
            }
            case 'B': {
                this.slide(180);
                break;
            }
            case 'e': {
                this.direction.setDirection(0);
                break;
            }
            case 'E': {
                this.slideDirection(0);
                break;
            }
            case 'n': {
                this.direction.setDirection(270);
                break;
            }
            case 'N': {
                this.slideDirection(270);
                break;
            }
            case 'w': {
                this.direction.setDirection(180);
                break;
            }
            case 'W': {
                this.slideDirection(180);
                break;
            }
            case 's': {
                this.direction.setDirection(90);
                break;
            }
            case 'S': {
                this.slideDirection(90);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal move character: '" + mv + "'");
            }
        }
    }

    public void move(String movement) {
        for (int i = 0; i < movement.length(); ++i) {
            this.move(movement.charAt(i));
        }
    }

    public final void move(Move movement) {
        this.move(movement.getMovementString());
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.x + '|' + this.y + ' ' + this.direction.toString() + "]";
    }
}

