/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.io.Serializable;
import java.util.ListIterator;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Predicates;
import orbital.math.Arithmetic;
import orbital.math.functional.Function;
import orbital.math.functional.Functionals;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractArithmetic;
import orbital.util.Setops;
import orbital.util.Utility;

abstract class AbstractProductArithmetic
extends AbstractArithmetic
implements Arithmetic,
Serializable {
    private static final long serialVersionUID = 1257583291254889178L;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractProductArithmetic() {
    }

    protected abstract Object productIndexSet(Arithmetic var1);

    protected abstract ListIterator iterator(Arithmetic var1);

    protected abstract Arithmetic newInstance(Object var1);

    public boolean equals(Object o) {
        if (o instanceof Arithmetic) {
            Arithmetic b = (Arithmetic)o;
            return Utility.equalsAll(this.productIndexSet(this), this.productIndexSet(b)) && Setops.all(this.iterator(this), this.iterator(b), Predicates.equal);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        ListIterator i = this.iterator(this);
        while (i.hasNext()) {
            Object e = i.next();
            hash ^= e == null ? 0 : e.hashCode();
        }
        return hash;
    }

    private Arithmetic operatorImpl(orbital.math.functional.BinaryFunction op, Arithmetic b) {
        if (!Utility.equalsAll(this.productIndexSet(this), this.productIndexSet(b))) {
            throw new IllegalArgumentException("a" + op + "b only defined for equal productIndexSet()");
        }
        Arithmetic ret = this.newInstance(this.productIndexSet(this));
        ListIterator dst = this.iterator(ret);
        Setops.copy(dst, Functionals.map((BinaryFunction)op, this.iterator(this), this.iterator(b)));
        if (!$assertionsDisabled && dst.hasNext()) {
            throw new AssertionError((Object)"equal productIndexSet() implies equal structure of iterators");
        }
        return ret;
    }

    private Arithmetic operatorImpl(Function op) {
        Arithmetic ret = this.newInstance(this.productIndexSet(this));
        ListIterator dst = this.iterator(ret);
        Setops.copy(dst, Functionals.map((orbital.logic.functor.Function)op, this.iterator(this)));
        if (!$assertionsDisabled && dst.hasNext()) {
            throw new AssertionError((Object)"equal productIndexSet() implies equal structure of iterators");
        }
        return ret;
    }

    public Arithmetic add(Arithmetic b) {
        return this.operatorImpl(Operations.plus, b);
    }

    public Arithmetic subtract(Arithmetic b) {
        return this.operatorImpl(Operations.subtract, b);
    }

    public Arithmetic scale(Arithmetic s) {
        return this.operatorImpl(Functionals.bindFirst(Operations.times, (Object)s));
    }

    public Arithmetic multiply(Arithmetic b) {
        return this.operatorImpl(Operations.times, b);
    }

    public Arithmetic minus() {
        return this.operatorImpl(Operations.minus);
    }

    public Arithmetic inverse() throws ArithmeticException {
        throw new UnsupportedOperationException();
    }

    static {
        $assertionsDisabled = !AbstractProductArithmetic.class.desiredAssertionStatus();
    }
}

