/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.util.Iterator;
import java.util.ListIterator;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Predicate;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Integer;
import orbital.math.Polynomial;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.functional.Function;
import orbital.math.functional.Functionals;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractProductArithmetic;
import orbital.util.Pair;
import orbital.util.Setops;

abstract class AbstractPolynomial
extends AbstractProductArithmetic
implements Polynomial {
    private static final long serialVersionUID = 4336092442446250306L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean equals(Object o) {
        if (o instanceof Polynomial) {
            final Polynomial b = (Polynomial)o;
            Setops.all(AbstractPolynomial.combinedIndices(this, b), new Predicate(){

                public boolean apply(Object o) {
                    Arithmetic i = (Arithmetic)o;
                    return AbstractPolynomial.this.get(i).equals(b.get(i));
                }
            });
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        ListIterator i = this.iterator(this);
        while (i.hasNext()) {
            Object e = i.next();
            hash += e == null ? 0 : e.hashCode();
        }
        return hash;
    }

    public Integer degree() {
        return Values.getDefaultInstance().valueOf(this.degreeValue());
    }

    protected abstract void set(Arithmetic var1, Arithmetic var2);

    protected Object productIndexSet(Arithmetic productObject) {
        return this.indexSet();
    }

    protected ListIterator iterator(Arithmetic productObject) {
        return ((Polynomial)productObject).iterator();
    }

    public Object apply(Object a) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Function derive() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Function integrate() {
        throw new ArithmeticException(this + " is only (undefinitely) integrable with respect to a single variable");
    }

    public Real norm() {
        return this.degreeValue() < 0 ? Values.ZERO : Values.POSITIVE_INFINITY;
    }

    protected Arithmetic operatorImpl(final BinaryFunction op, Arithmetic bb) {
        final Polynomial b = (Polynomial)bb;
        if (!this.indexSet().equals(b.indexSet())) {
            throw new IllegalArgumentException("a" + op + "b only defined for equal indexSet()");
        }
        Polynomial ret = (Polynomial)this.newInstance(this.indexSet());
        ListIterator dst = ret.iterator();
        Setops.copy(dst, Functionals.map(new orbital.logic.functor.Function(){

            public Object apply(Object o) {
                Arithmetic i = (Arithmetic)o;
                return op.apply(AbstractPolynomial.this.get(i), b.get(i));
            }
        }, AbstractPolynomial.combinedIndices(this, b)));
        if (!$assertionsDisabled && dst.hasNext()) {
            throw new AssertionError((Object)"equal indexSet() for iterator view implies equal structure of iterators");
        }
        return ret;
    }

    public Arithmetic add(Arithmetic b) {
        return this.add((Polynomial)b);
    }

    public Polynomial add(Polynomial b) {
        return (Polynomial)this.operatorImpl(Operations.plus, b);
    }

    public Arithmetic subtract(Arithmetic b) throws ArithmeticException {
        return this.subtract((Polynomial)b);
    }

    public Polynomial subtract(Polynomial b) {
        return (Polynomial)this.operatorImpl(Operations.subtract, b);
    }

    public Arithmetic multiply(Arithmetic b) {
        return this.multiply((Polynomial)b);
    }

    public Polynomial multiply(Polynomial bb) {
        Polynomial b = bb;
        if (this.degreeValue() < 0) {
            return this;
        }
        if (b.degreeValue() < 0) {
            return b;
        }
        AbstractPolynomial ret = (AbstractPolynomial)this.newInstance(this.indexSet());
        this.setAllZero(ret);
        Iterator index = Setops.cross(this.indices(), b.indices());
        while (index.hasNext()) {
            Pair pair = (Pair)index.next();
            Arithmetic i = (Arithmetic)pair.A;
            Arithmetic j = (Arithmetic)pair.B;
            Arithmetic Xij = i.add(j);
            Arithmetic aibj = this.get(i).multiply(b.get(j));
            Arithmetic cXij = ret.get(Xij);
            ret.set(Xij, cXij != null ? cXij.add(aibj) : aibj);
        }
        return ret;
    }

    void setAllZero(Polynomial p) {
        Arithmetic ZERO = this.get((Arithmetic)this.indices().next()).zero();
        ListIterator i = p.iterator();
        while (i.hasNext()) {
            i.next();
            i.set(ZERO);
        }
    }

    public Arithmetic divide(Arithmetic b) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("dividing polynomials is not generally defined");
    }

    public Arithmetic inverse() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("inverse of polynomials is not generally defined");
    }

    public String toString() {
        return ArithmeticFormat.getDefaultInstance().format(this);
    }

    private static final Iterator combinedIndices(Polynomial f, Polynomial g) {
        return Setops.union(Setops.asList(f.indices()), Setops.asList(g.indices())).iterator();
    }

    static {
        $assertionsDisabled = !AbstractPolynomial.class.desiredAssertionStatus();
    }
}

