/*
 * Decompiled with CFR 0.152.
 */
package orbital.awt;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintStream;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import orbital.util.InnerCheckedException;

public final class UIUtilities {
    private static JRadioButtonMenuItem metalMenuItem;

    private UIUtilities() {
    }

    public static void setCenter(Component comp, Component parent) {
        if (parent == null) {
            UIUtilities.setCenter(comp);
            return;
        }
        Dimension dlgSize = comp.getPreferredSize();
        Dimension frmSize = parent.getSize();
        Point loc = parent.getLocation();
        if (dlgSize.width < frmSize.width && dlgSize.height < frmSize.height) {
            comp.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        } else {
            UIUtilities.setCenter(comp);
        }
    }

    public static void setCenter(Component comp) {
        Dimension screenSize = comp.getToolkit().getScreenSize();
        Dimension frameSize = comp.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        comp.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void drawCenteredString(Graphics g, String text, int cx, int cy) {
        FontMetrics fm = g.getFontMetrics();
        int sWidth = fm.stringWidth(text);
        int sHeight = -8;
        g.drawString(text, cx - sWidth / 2, cy - sHeight / 2);
    }

    public static Window getParentalWindow(Component n) {
        while (!(n instanceof Window) && n != null) {
            n = n.getParent();
        }
        return (Window)n;
    }

    public static Frame getParentalFrame(Component n) {
        while (!(n instanceof Frame) && n != null) {
            n = n.getParent();
        }
        return (Frame)n;
    }

    public static void addLookAndFeelMenuItems(Component root, JMenu view) {
        ButtonGroup group = new ButtonGroup();
        ToggleUIListener toggleUIListener = new ToggleUIListener(root);
        metalMenuItem = (JRadioButtonMenuItem)view.add(new JRadioButtonMenuItem("Java Look and Feel"));
        metalMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Metal"));
        group.add(metalMenuItem);
        metalMenuItem.addItemListener(toggleUIListener);
        metalMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        JRadioButtonMenuItem motifMenuItem = (JRadioButtonMenuItem)view.add(new JRadioButtonMenuItem("Motif Look and Feel"));
        motifMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("CDE/Motif"));
        group.add(motifMenuItem);
        motifMenuItem.addItemListener(toggleUIListener);
        motifMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        JRadioButtonMenuItem windowsMenuItem = (JRadioButtonMenuItem)view.add(new JRadioButtonMenuItem("Windows Style Look and Feel"));
        windowsMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Windows"));
        group.add(windowsMenuItem);
        windowsMenuItem.addItemListener(toggleUIListener);
        windowsMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
    }

    public static void setDefaultLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printBean(Class beanClass) {
        UIUtilities.printBean(beanClass, System.out);
    }

    public static void printBean(Class beanClass, PrintStream ps) {
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass, 1);
            if (info == null) {
                throw new NullPointerException("no BeanInfo for class: " + beanClass);
            }
            BeanDescriptor desc = info.getBeanDescriptor();
            if (desc == null) {
                throw new NullPointerException("no BeanDescriptor for class: " + beanClass);
            }
            ps.println(UIUtilities.info(desc) + " " + desc.getBeanClass() + " " + info);
            PropertyDescriptor[] beanProperties = info.getPropertyDescriptors();
            if (beanProperties == null) {
                throw new NullPointerException("no PropertyDescriptors for class: " + beanClass);
            }
            for (int i = 0; i < beanProperties.length; ++i) {
                if (beanProperties[i].isHidden()) continue;
                ps.println(UIUtilities.info(beanProperties[i]));
            }
        }
        catch (IntrospectionException e) {
            throw new InnerCheckedException("bean not introspectable", e);
        }
    }

    public static String info(FeatureDescriptor desc) {
        StringBuffer sb = new StringBuffer();
        sb.append(desc.getName());
        if (!desc.getName().equals(desc.getDisplayName())) {
            sb.append(" '" + desc.getDisplayName() + "'");
        }
        if (!desc.getName().equals(desc.getShortDescription())) {
            sb.append(System.getProperty("line.separator") + "  \"" + desc.getShortDescription() + '\"');
        }
        return sb.toString();
    }

    public static String info(PropertyDescriptor desc) {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(UIUtilities.info((FeatureDescriptor)desc) + nl + "  " + desc.getPropertyType() + ", ");
        if (desc.getReadMethod() != null) {
            if (desc.getWriteMethod() != null) {
                sb.append("readwrite");
            } else {
                sb.append("readonly");
            }
        } else if (desc.getWriteMethod() != null) {
            sb.append("writeonly");
        } else {
            sb.append("inaccessible");
        }
        sb.append(", " + (desc.isBound() ? "bound" : "not bound") + ", " + (desc.isConstrained() ? "constrained" : "not constrained"));
        return sb.toString();
    }

    static class ToggleUIListener
    implements ItemListener {
        protected Component root;

        public ToggleUIListener(Component root) {
            this.root = root;
        }

        public void itemStateChanged(ItemEvent e) {
            this.root.setCursor(Cursor.getPredefinedCursor(3));
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
            try {
                if (rb.isSelected() && rb.getText().equals("Windows Style Look and Feel")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(this.root);
                } else if (rb.isSelected() && rb.getText().equals("Macintosh Look and Feel")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(this.root);
                } else if (rb.isSelected() && rb.getText().equals("Motif Look and Feel")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(this.root);
                } else if (rb.isSelected() && rb.getText().equals("Java Look and Feel")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(this.root);
                }
            }
            catch (UnsupportedLookAndFeelException exc) {
                rb.setEnabled(false);
                System.err.println("Unsupported LookAndFeel: " + rb.getText());
                try {
                    metalMenuItem.setSelected(true);
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(this.root);
                }
                catch (Exception exc2) {
                    exc2.printStackTrace();
                    System.err.println("Could not load LookAndFeel: " + exc2);
                    exc2.printStackTrace();
                }
            }
            catch (Exception exc) {
                rb.setEnabled(false);
                exc.printStackTrace();
                System.err.println("Could not load LookAndFeel: " + rb.getText());
                exc.printStackTrace();
            }
            this.root.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

