/*
 * Decompiled with CFR 0.152.
 */
package orbital.algorithm;

import java.util.Arrays;
import java.util.NoSuchElementException;
import orbital.algorithm.Combinatorical;
import orbital.math.MathUtilities;

class RepetitiveCombination
extends Combinatorical {
    private static final long serialVersionUID = -7887257459549546388L;
    private int r;
    private int n;
    private int[] combination;

    public RepetitiveCombination(int r, int n) {
        this.r = r;
        this.n = n;
        this.combination = new int[r];
        Arrays.fill(this.combination, 0);
        int n2 = this.combination.length - 1;
        this.combination[n2] = this.combination[n2] - 1;
    }

    public boolean hasNext() {
        for (int i = this.combination.length - 1; i >= 0; --i) {
            if (this.combination[i] + 1 >= this.n) continue;
            return true;
        }
        return false;
    }

    public int[] next() {
        for (int i = this.combination.length - 1; i >= 0; --i) {
            if (this.combination[i] + 1 >= this.n) continue;
            int n = i;
            this.combination[n] = this.combination[n] + 1;
            for (int j = i + 1; j < this.combination.length; ++j) {
                this.combination[j] = this.combination[j - 1];
            }
            return this.combination;
        }
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int[] previous() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int count() {
        return MathUtilities.nCr(this.n + this.r - 1, this.r);
    }

    public String toString() {
        return this.getClass().getName() + "[of " + this.r + " elements out of " + this.n + "]";
    }
}

