/*
 * Decompiled with CFR 0.152.
 */
package functologic.game.computer;

import functologic.game.computer.Field;
import functologic.game.computer.StandardHeuristic;
import functologic.game.computer.StandardHeuristicTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import orbital.game.FigureImpl;
import orbital.logic.functor.Function;
import orbital.math.ValueFactory;
import orbital.math.Values;
import orbital.robotic.Position;

public class PositionalHeuristic
implements Serializable {
    private static final ValueFactory valueFactory = Values.getDefaultInstance();
    private static final String kindDescriptions = "heuristic summing the position value of figures on the board";
    private static final int FRIEND = 0;
    private static final int FOE = 1;
    private static final int LEAGUE_REL = 2;
    private static final String[] leagueRelDescriptors = new String[]{"friend", "foe"};
    static /* synthetic */ Class class$functologic$game$computer$PositionalHeuristic;

    public static List createHeuristics(double[][][] dArray, Function function, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (dArray3 == null) {
            dArray3 = new double[dArray2.length];
            Arrays.fill(dArray3, Double.NEGATIVE_INFINITY);
        }
        if (dArray4 == null) {
            dArray4 = new double[dArray2.length];
            Arrays.fill(dArray4, Double.POSITIVE_INFINITY);
        }
        ArrayList<Positional> arrayList = new ArrayList<Positional>(2 * dArray.length);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                arrayList.add(new Positional(i, j, dArray[j], function));
            }
        }
        return StandardHeuristicTransformer.createHeuristics(PositionalHeuristic.duplicate(dArray2), PositionalHeuristic.duplicate(dArray3), PositionalHeuristic.duplicate(dArray4), arrayList);
    }

    private static final double[] duplicate(double[] dArray) {
        double[] dArray2 = new double[2 * dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        System.arraycopy(dArray, 0, dArray2, dArray.length, dArray.length);
        return dArray2;
    }

    static class Positional
    implements StandardHeuristic,
    Serializable {
        private static final long serialVersionUID = 5997493782492943771L;
        private final int forleagueRel;
        private final int mode;
        private final double[][] positionValues;
        private final Function coordinates;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Positional(int n, int n2, double[][] dArray, Function function) {
            this.forleagueRel = n;
            this.mode = n2;
            this.positionValues = dArray;
            this.coordinates = function;
        }

        public Object apply(Object object) {
            int n;
            FigureImpl figureImpl = (FigureImpl)object;
            int n2 = ((Field)figureImpl.getField()).getOurLeague();
            int n3 = figureImpl.getLeague();
            int n4 = n = n3 == n2 ? 0 : 1;
            if (!$assertionsDisabled && n3 <= 0) {
                throw new AssertionError((Object)"non-empty figures don't belong to no one");
            }
            Position position = (Position)this.coordinates.apply(figureImpl);
            int n5 = position.x;
            int n6 = position.y;
            if (this.forleagueRel != n) {
                return Values.ZERO;
            }
            return valueFactory.valueOf(this.positionValues[n5][n6]);
        }

        public String toString() {
            return "Positional[" + leagueRelDescriptors[this.forleagueRel] + ' ' + this.mode + "]";
        }

        public String getDescription() {
            return "heuristic summing the position value of figures on the board " + this.mode + " \nfor " + leagueRelDescriptors[this.forleagueRel];
        }

        static {
            $assertionsDisabled = !(class$functologic$game$computer$PositionalHeuristic == null ? (class$functologic$game$computer$PositionalHeuristic = PositionalHeuristic.class$("functologic.game.computer.PositionalHeuristic")) : class$functologic$game$computer$PositionalHeuristic).desiredAssertionStatus();
        }
    }
}

