/*
 * Decompiled with CFR 0.152.
 */
package functologic.game.computer;

import functologic.game.computer.Field;
import functologic.game.computer.StandardHeuristicTransformer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import orbital.game.AdversarySearch;
import orbital.game.Figure;
import orbital.logic.functor.Function;
import orbital.robotic.Move;
import orbital.robotic.Position;

public class MoveOptionHeuristic
implements Serializable {
    private static final long serialVersionUID = 1595126666337128336L;
    protected static final int MOVE = 0;
    protected static final int COVER = 1;
    protected static final int THREATEN = 2;
    protected static final int MOBILITY = 3;
    protected static final int GUARDED = 4;
    static final int MODE_COUNT = 5;
    private static final String[] modeDescriptors;
    private static final String[] modeDescriptions;
    private static final int FRIEND = 0;
    private static final int FOE = 1;
    private static final int LEAGUE_REL = 2;
    private static final String[] leagueRelDescriptors;
    private transient int[][] count;
    static final /* synthetic */ boolean $assertionsDisabled;

    private MoveOptionHeuristic() {
    }

    private int[][] getCount(Field field) {
        return this.count;
    }

    public static List createHeuristics(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray2 == null) {
            dArray2 = new double[dArray.length];
            Arrays.fill(dArray2, Double.NEGATIVE_INFINITY);
        }
        if (dArray3 == null) {
            dArray3 = new double[dArray.length];
            Arrays.fill(dArray3, Double.POSITIVE_INFINITY);
        }
        final MoveOptionHeuristic moveOptionHeuristic = new MoveOptionHeuristic();
        Function[] functionArray = new Function[10];
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                MoveOptionHeuristicPart moveOptionHeuristicPart;
                int n2 = n++;
                if (i == 0 && j == 0) {
                    MoveOptionHeuristic moveOptionHeuristic2 = moveOptionHeuristic;
                    moveOptionHeuristic2.getClass();
                    moveOptionHeuristicPart = new MoveOptionHeuristicPart(moveOptionHeuristic2, i, j, dArray[j], dArray2[j], dArray3[j]){
                        private static final long serialVersionUID = 3395793432758875445L;
                        {
                            MoveOptionHeuristic moveOptionHeuristic3 = moveOptionHeuristic4;
                            moveOptionHeuristic3.getClass();
                            super(n, n2, d, d2, d3);
                        }

                        public Object apply(Object object) {
                            moveOptionHeuristic.init((Field)object);
                            return super.apply(object);
                        }
                    };
                } else {
                    MoveOptionHeuristic moveOptionHeuristic3 = moveOptionHeuristic;
                    moveOptionHeuristic3.getClass();
                    moveOptionHeuristicPart = moveOptionHeuristic3.new MoveOptionHeuristicPart(i, j, dArray[j], dArray2[j], dArray3[j]);
                }
                functionArray[n2] = moveOptionHeuristicPart;
            }
        }
        return Arrays.asList(functionArray);
    }

    private void init(Field field) {
        int n;
        Object object;
        int n2 = field.getOurLeague();
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError((Object)"our league is not just no one");
        }
        if (this.count == null) {
            this.count = new int[2][5];
        }
        for (int i = 0; i < 2; ++i) {
            Arrays.fill(this.count[i], 0);
        }
        boolean[][][] blArray = new boolean[2][field.getDimension().width][field.getDimension().height];
        for (int i = 0; i < blArray.length; ++i) {
            object = blArray[i];
            for (n = 0; n < ((boolean[][])object).length; ++n) {
                Arrays.fill((boolean[])object[n], false);
            }
        }
        Iterator iterator = field.iterateNonEmpty();
        while (iterator.hasNext()) {
            int n3;
            object = (Figure)iterator.next();
            n = ((Figure)object).getLeague();
            int n4 = n3 = n == n2 ? 0 : 1;
            if (!$assertionsDisabled && n <= 0) {
                throw new AssertionError((Object)"non-empty figures don't belong to no one");
            }
            Iterator iterator2 = ((Figure)object).possibleMoves();
            while (iterator2.hasNext()) {
                AdversarySearch.Option option = (AdversarySearch.Option)iterator2.next();
                Move move = option.getMove();
                Position position = option.getDestination();
                int[] nArray = this.count[n3];
                nArray[3] = nArray[3] + 1;
                int n5 = field.isBeating(move, position);
                if (n5 == 0) {
                    int[] nArray2 = this.count[n3];
                    nArray2[0] = nArray2[0] + 1;
                } else {
                    boolean bl = n == n5;
                    int[] nArray3 = this.count[n3];
                    int n6 = bl ? 1 : 2;
                    nArray3[n6] = nArray3[n6] + 1;
                }
                if (!move.isBeating(move.length() - 1)) continue;
                blArray[n3][position.x][position.y] = true;
            }
        }
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < blArray[i].length; ++j) {
                for (n = 0; n < blArray[i][j].length; ++n) {
                    if (!blArray[i][j][n]) continue;
                    int[] nArray = this.count[i];
                    nArray[4] = nArray[4] + 1;
                }
            }
        }
    }

    static {
        $assertionsDisabled = !MoveOptionHeuristic.class.desiredAssertionStatus();
        modeDescriptors = new String[]{"MOVE", "COVER", "THREATEN", "MOBILITY", "GUARDED"};
        modeDescriptions = new String[]{"heuristic evaluating number of possible normal moves", "heuristic evaluating number of possible attacks to a field that an ally inhabits", "heuristic evaluating number of possible attacks to a foe", "heuristic evaluating mobility, i.e. number of normal moves or attacks somewhere", "heuristic evaluating number of fields that we have a theoretical attack option, regardless of its ownership"};
        leagueRelDescriptors = new String[]{"friend", "foe"};
    }

    private class MoveOptionHeuristicPart
    extends StandardHeuristicTransformer.StandardHeuristicPart {
        private static final long serialVersionUID = -7271977330765581216L;
        private final int leagueRel;
        private final int mode;

        public MoveOptionHeuristicPart(int n, int n2, double d, double d2, double d3) {
            super(d, d2, d3);
            this.leagueRel = n;
            this.mode = n2;
        }

        public Object apply(Object object) {
            return this.transform(MoveOptionHeuristic.this.getCount((Field)object)[this.leagueRel][this.mode]);
        }

        public String toString() {
            return "MoveOption[" + leagueRelDescriptors[this.leagueRel] + ' ' + modeDescriptors[this.mode] + "]";
        }

        public String getDescription() {
            return modeDescriptions[this.mode] + " \nfor " + leagueRelDescriptors[this.leagueRel];
        }
    }
}

